//
//	NetworkStat.js
//	Widgets
/*

Copyright 2005, Pascal Pfiffner.

*/


//	Globals
// default-settings: 'whilehidden', 7200, false

var seconds = getTimer();		// seconds left till next refresh
var refreshMode = getRefreshMode();			// refresh-mode
var refreshOnShow = getRefreshOnShow();		// refresh on every Dashboard-activation?
var stylesheet = getStylesheet();

var doCountdown = (refreshMode == 'manual') ? 0 : 1;		// countdown active or not?
var lastRefresh = new Date();
var the_interval;


function showVersion() {
	document.getElementById('infospan').innerHTML = "version 1.2";
}


// Dashboard Setup by Apple (sets the stylesheet, creates the "done" button and refreshes for the first time)
function setup() {
	setStylesheet(stylesheet);		// set stylesheet matching prefs
	document.getElementById('refreshbutton').src = "Images_" + stylesheet + "/loopback.png";	// set refreshbutton matching stylesheet
	createGenericButton(document.getElementById("done"), "done", savePrefs);
	
	setTimeout("refreshState()", 20);
}


//	Main Functions

function refreshState() {		// refresh info
	setTimer("in progress...");
	window.clearInterval(the_interval);
	
	if(window.widget) {
		
		// Location
		setLocation("checking...");
		setLocation(widget.system("./get_location.pl", null).outputString);
		
		purgeInterfaces();
		
		// Internal
		addParagraph("checking...", "None");	// add the checking-indicator
		adjustTotalSize();						// adjusts widget size
		var internals = widget.system("./get_internal.pl", null).outputString;
		var interfaces = internals.split("|");
		purgeLastChild('maincontent');
		
		var iface_count = 0;
		var iparr = new Array();
		for(i = 0; i < interfaces.length; i++) {
			if(interfaces[i].length > 0) {
				var parts = interfaces[i].split("?");		// 0 = interface, 1 = IPv4, 2 = IPv6, 3 = prefixlen, 4 = netmask, 5 = broadcast, 6 = MAC
				addParagraph(parts[1], parts[0], 0);
				if(parts[2])
					addParagraph(parts[2] +"?"+ parts[3] +"?"+ parts[4] +"?"+ parts[5] +"?"+ parts[6], 0, "interface_more");
				iparr[iface_count] = parts[1];
				iface_count++;
			}
		}
		
		
		// External
		addParagraph("checking...", "Internet", 0);		// adds another checking-indicator
		adjustTotalSize();						// the checking-indicator should be inside the widget
		var external = widget.system("/usr/bin/curl --connect-timeout 10 -s www.whatismyip.org", null).outputString;
		if(! external)
			external = "no network";
		
		purgeLastChild('maincontent');
		if( ! (iface_count == 1 && iparr[0] == external))		// only add external if it`s not the same as the single internal IP
			addParagraph(external, "Internet", 0);
		else
			adjustTotalSize();		// finally adjust total size if we show no external IP
	}
	else {
		setLocation("still unknown");
		
		purgeInterfaces();
		addParagraph("still unknown", "None", 0);
		adjustTotalSize();
	}
	
	setTimer("done");		// set the timer (countdown will reset it in a second, but lets do that anyway)
	
	lastRefresh = new Date();
	document.getElementById('lastRefresh').innerHTML = formatDate(lastRefresh);
	
	seconds = getTimer();
	countdown();
}


function countdown() {		// display time left to refresh and initiate refresh on t=0
	if(doCountdown && (refreshMode != 'manual')) {
		if(seconds > 3600) {
			if(seconds % 3600 == 0)
				setTimer("in " + (seconds/3600) + " hours");
			else {
				var hours = Math.floor(seconds / 3600);
				var minutes = Math.floor((seconds % 3600) / 60);
				setTimer("in " + hours + ((hours == 1) ? " hour" : "hours") + " " + minutes + ((minutes == 1) ? " minute" : "minutes"));
			}
			
			seconds -= 60;
			
			window.clearInterval(the_interval);
			the_interval = window.setInterval("countdown()", 60000);
		}
		
		else if(seconds > 60) {
			setTimer("in about " + Math.ceil(seconds / 60) + " minutes");
			
			seconds -= 60;
			if(seconds < 60)
				seconds = 60;
			
			window.clearInterval(the_interval);
			the_interval = window.setInterval("countdown()", 60000);
		}
		
		else if(seconds > 0) {
			setTimer("in " + seconds + ((seconds == 1) ? " second" : " seconds"));
			seconds--;
			
			window.clearInterval(the_interval);
			the_interval = window.setInterval("countdown()", 996);
		}
		
		else {
			refreshState();
		}
	}
	
	
	else {
		window.clearInterval(the_interval);
		setTimer("MANUALLY");
	}
}


function setTimer(text) {
	document.getElementById('timer').innerHTML = text;
}


function setLocation(loc) {
	document.getElementById('location').innerHTML = loc;
}


function purgeInterfaces() {
	var parent = document.getElementById('maincontent');
	var elements = parent.childNodes;
	var a = elements.length;
	
	for(i = a; i > 0; i--) {
		if(elements[i] && elements[i].nodeName == 'P')
			parent.removeChild(elements[i]);
	}
}

function purgeLastChild(id) {
	var parent = document.getElementById(id);
	parent.removeChild(parent.lastChild);
}


function addParagraph(imploded_data, iface, my_class) {
	var parent = document.getElementById('maincontent');
	var data = imploded_data.split("?");		// 0 = interface, 1 = IPv4, 2 = IPv6, 3 = prefixlen, 4 = netmask, 5 = broadcast, 6 = MAC
	
	// <p>
	var paragraph = document.createElement('p');
	if(my_class) {
		var this_class = document.createAttribute('class');
		this_class.nodeValue = my_class;
		paragraph.setAttributeNode(this_class);
	}
	
	// Interface-Image
	if(iface) {
		var img = document.createElement('img');
		var img_src = document.createAttribute('src');
		img_src.nodeValue = "Images_" + stylesheet + "/" + iface + ".png";
		var img_class = document.createAttribute('class');
		img_class.nodeValue = "interface_img";
		var img_onclick = document.createAttribute('onclick');
		img_onclick.nodeValue = "toggleMoreInfo(this.parentNode)";
		
		img.setAttributeNode(img_src);
		img.setAttributeNode(img_class);
		img.setAttributeNode(img_onclick);
	}
		
	// <a>
	var link = new Array();
	var a = 0;
	for(b = 0; b < data.length; b++) {
		if(data[b].length > 0) {
			link[a] = document.createElement('a');
			
			var link_href = document.createAttribute('href');
			link_href.nodeValue = "javascript:toClipboard('" + data[b] + "');";
			link[a].setAttributeNode(link_href);
			
			var link_class = document.createAttribute('class');
			link_class.nodeValue = (data.length > 1) ? "data" : "data_big";
			link[a].setAttributeNode(link_class);
			
			var link_data = document.createTextNode(data[b]);
			link[a++].appendChild(link_data);
		}
	}
	
	
	// combine
	if(link.length > 1) {									// IPv6 and stuff
		for(b = 0; b < link.length; b++) {
			paragraph.appendChild(link[b]);
			
			if(b == 0)
				paragraph.appendChild(document.createTextNode(" | "));
			else if(b == 1) {
				paragraph.appendChild(document.createElement('br'));
				paragraph.appendChild(document.createTextNode("mask "));
			}
			else if(b == 2) {
				paragraph.appendChild(document.createElement('br'));
				paragraph.appendChild(document.createTextNode("b-cast "));
			}
			else if(b == 3 && link.length > 4) {
				paragraph.appendChild(document.createElement('br'));
				paragraph.appendChild(document.createTextNode("MAC "));
			}
		}
	}
	else {													// one IP only
		if(img)
			paragraph.appendChild(img);
		paragraph.appendChild(link[0]);
	}
	
	parent.appendChild(paragraph);
}


function toClipboard(value) {
	if(window.widget) {
		widget.system("./toClipboard.sh '" + value + "'", null);
	}
}






/*
 ******************
 * Pref Functions *
 ******************
 */

function getTimer() {		// get refresh-timer from prefs
	if(window.widget) {
		var value = widget.preferenceForKey("timer");
	}
	
	return value ? value : 7200;
}

function getRefreshMode() {		// get mode from prefs (whilehidden, resume)
	if(window.widget) {
		var value = widget.preferenceForKey("refreshMode");
	}
	
	return value ? value : "whilehidden";
}

function getRefreshOnShow() {		// get from prefs
	if(window.widget) {
		var value = widget.preferenceForKey("refreshOnShow");
	}
	
	return value ? true : false;
}

function getStylesheet() {		// get from prefs
	if(window.widget) {
		var value = widget.preferenceForKey("stylesheet");
	}
	
	return value ? value : 2;
}


function setStylesheet(style) {
	if(! style)
		style = 1;
	
	var stylelink = document.getElementById('stylesheetlink');
	stylelink.href = "./NetworkStat_" + style + ".css";
}


function adjustPrefs() {
	// timer
	var myseconds = getTimer();
	var timerelem = document.forms[0].timer;
	
	if(refreshMode == 'manual') {
		timerelem.options[0].selected = true;
	}
	else {
		for(i = 0; i < timerelem.childNodes.length; i++) {
			if(timerelem.options[i].value == myseconds) {
				timerelem.options[i].selected = true;
				break;
			}
		}
	}
	
	// refresh-mode
	checkIfManually();
	if(refreshMode == "whilehidden")
		document.forms[0].refresh.options[0].selected = true;
	else if(refreshMode == "resume")
		document.forms[0].refresh.options[1].selected = true;
	
	// onShow-refresh
	if(refreshOnShow)
		document.forms[0].onshow.checked = true;
	
	// selected stylesheet
	if(getStylesheet() == 2)
		document.forms[0].style[1].checked = true;
	else
		document.forms[0].style[0].checked = true;
}


function checkIfManually() {
	if(document.forms[0].timer.selectedIndex == 0) {
		document.forms[0].refresh.disabled = true;
	}
	else {
		document.forms[0].refresh.disabled = false;
	}
}

function savePrefs() {
	// timer
	var timerelem = document.forms[0].timer;
	var timer = timerelem.options[timerelem.selectedIndex].value;
	timer = (timer == 'manual') ? 7200 : timer;
	
	// mode
	if(timerelem.options[timerelem.selectedIndex].value == 'manual')
		var mode = 'manual';
	else if(document.forms[0].refresh[1].selected == true)
		var mode = "resume";
	else
		var mode = "whilehidden";
	
	// onshow
	var onShow = document.forms[0].onshow.checked ? true : false;
	
	// stylesheet
	var style = (document.forms[0].style[1].checked == true) ? 2 : 1;
	
	if(window.widget) {
		widget.setPreferenceForKey(timer, "timer");
		widget.setPreferenceForKey(mode, "refreshMode");
		widget.setPreferenceForKey(onShow, "refreshOnShow");
		widget.setPreferenceForKey(style, "stylesheet");
	}
	
	hidePrefs();
}

function showPrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	adjustPrefs();
	showVersion();
	
	if(window.widget)
		widget.prepareForTransition("ToBack");
				
	front.style.display = "none";
	back.style.display = "block";
		
	if(window.widget)
		setTimeout("widget.performTransition();", 0);  
}

function hidePrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	stylesheet = getStylesheet();
	setStylesheet(stylesheet);
	document.getElementById('refreshbutton').src = "Images_" + stylesheet + "/loopback.png";	// set refreshbutton matching stylesheet
	
	seconds = getTimer();
	refreshMode = getRefreshMode();
	refreshOnShow = getRefreshOnShow();
	doCountdown = (refreshMode == 'manual') ? 0 : 1;
	
	countdown();
	
	if(window.widget)
		widget.prepareForTransition("ToFront");
				
	front.style.display = "block";
	back.style.display = "none";
		
	if(window.widget)
		setTimeout("widget.performTransition();", 0);
}



//	Localization
/*
function getLocalizedString (key)
{
	try {
		return localizedStrings[key];
	} catch (ex) {}

	return key;
}
*/




/*
 **********
 * Events *
 **********
 */

if(window.widget) {
	widget.onshow = onShow;
	widget.onhide = onHide;
}


function onShow() {
	doCountdown = (refreshMode == 'manual') ? 0 : 1;

	if(refreshOnShow)
		 refreshState();
	
	if(refreshMode == 'resume')		// by now, doCountdown must be 1; else we`re refreshing manually and there needs to be no countdown
		countdown();
	
}

function onHide() {	
	if(refreshMode == 'resume')
		doCountdown = 0;
}



/*
 ********************
 * GUI manipulation *
 ********************
 */


function blendFromTo(from_id, to_id) {
	var from = document.getElementById(from_id);
	var to = document.getElementById(to_id);
	
	if(from && to) {
		from.style.display = 'none';
		to.style.display = 'block';
	}
}


function toggleMoreInfo(obj) {
	var moreinfo = obj.nextSibling;
	if(moreinfo == null)
		return;
	
	if(moreinfo.style.display == 'block')
		moreinfo.style.display = 'none';
	else
		moreinfo.style.display = 'block';
	
	adjustTotalSize();
}


var resize = { timer:null, from:44, to:44, window:false };

function adjustTotalSize() {
	if(resize.timer) {
		clearInterval(resize.timer);
		resize.timer = null;
	}
	
	var reference = document.getElementById('maincontent');
	var scale = document.getElementById('maincontainer');
	
	resize.to = document.defaultView.getComputedStyle(reference).getPropertyValue('height').replace(/px/, '') * 1;
	resize.from = document.defaultView.getComputedStyle(scale).getPropertyValue('height').replace(/px/, '');
		
	//alert('resize from ' + resize.from + ' to ' + resize.to + ' initiating');
	
	resize.window = false;
	resize.timer = setInterval("resizeDiv('maincontainer')", 30);
	resizeDiv('maincontainer');
}

function resizeDiv(div) {
	var topheight = 54;
	var diff = resize.to - resize.from;
	var by = (diff > 0) ? Math.ceil(diff * 0.25) : Math.floor(diff * 0.25);
	resize.from = resize.from * 1 + by;
	
	if(by != 0) {
		// alert('doing a resize by ' + by + ' to ' + resize.from + ', total diff ' + diff);
		if(window.widget && diff > 0 && ! resize.window) {
			window.resizeTo(250, ((resize.to + 18 + topheight) < 140) ? 140 : (resize.to + 18 + topheight));
			resize.window = true;
		}
		document.getElementById(div).style.height = resize.from + 'px';
	}
	else {
		clearInterval(resize.timer);
		if(window.widget && ! resize.window) {
			window.resizeTo(250, ((resize.to + 18 + topheight) < 140) ? 140 : (resize.to + 18 + topheight));
			resize.window = true;
		}
	}
}


function formatDate(stamp) {
	if(!stamp)
		stamp = new Date();
	
	var day = stamp.getDate();
	var month = stamp.getMonth() + 1;
	var year = stamp.getFullYear();
	var hour = stamp.getHours();
	hour = (hour < 10) ? "0" + hour : hour;
	var minute = stamp.getMinutes();
	minute = (minute < 10) ? "0" + minute : minute;
	
	var formatted = day + "." + month + "." + year + " " + hour + ":" + minute;
	return formatted;
}



/*
 **************
 *  by Apple  *
 **************
 */

var flipShown = false;
var animation = { duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null };

function mousemove(event) {
	if(!flipShown) {
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;
		}
 
		var starttime = (new Date).getTime() - 13;
 
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('flip');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}


function mouseexit(event) {
	if(flipShown) {
		
		// fade out the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}

		var starttime = (new Date).getTime() - 13;

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function animate() {
	var T;
	var ease;
	var time = (new Date).getTime();
	
	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration) {
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}

function limit_3(a, b, c) {
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat(from, to, ease) {
	return from + (to - from) * ease;
}


// these functions are called when the info button itself receives onmouseover and onmouseout events (by Apple)

function enterflip(event) {
	document.getElementById("fliprollie").style.display = "block";
}

function exitflip(event) {
	document.getElementById("fliprollie").style.display = "none";
}




